<?= $this->include('layout/header_admin') ?>

<div class="container mt-4">
    <h3 class="mb-4 text-primary">📊 Dashboard Admin</h3>

    <!-- Flash Message -->
    <?php if (session()->getFlashdata('success')): ?>
        <div class="alert alert-success">
            <?= session()->getFlashdata('success') ?>
        </div>
    <?php endif; ?>

    <div class="row g-3">

        <!-- Card 1: Total Admin -->
        <div class="col-md-4">
            <div class="card shadow-sm border-start border-primary border-4">
                <div class="card-body">
                    <div class="d-flex align-items-center">
                        <div class="flex-grow-1">
                            <h5>Total Admin</h5>
                            <h3 class="text-primary"><?= isset($totalAdmin) ? $totalAdmin : 0 ?></h3>
                        </div>
                        <div>
                            <i class="bi bi-person-badge fs-1 text-primary"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Card 2: Total Aktivitas -->
        <div class="col-md-4">
            <div class="card shadow-sm border-start border-success border-4">
                <div class="card-body">
                    <div class="d-flex align-items-center">
                        <div class="flex-grow-1">
                            <h5>Total Aktivitas</h5>
                            <h3 class="text-success"><?= isset($totalAktivitas) ? $totalAktivitas : 0 ?></h3>
                        </div>
                        <div>
                            <i class="bi bi-journal-text fs-1 text-success"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Card 3: Total Pendidikan -->
        <div class="col-md-4">
            <div class="card shadow-sm border-start border-warning border-4">
                <div class="card-body">
                    <div class="d-flex align-items-center">
                        <div class="flex-grow-1">
                            <h5>Total Pendidikan</h5>
                            <h3 class="text-warning"><?= isset($totalPendidikan) ? $totalPendidikan : 0 ?></h3>
                        </div>
                        <div>
                            <i class="bi bi-mortarboard fs-1 text-warning"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

    </div>

    <!-- Quick Links -->
    <div class="row mt-4">
        <div class="col-md-12">
            <div class="card shadow-sm">
                <div class="card-body">
                    <h5 class="card-title mb-3">📌 Quick Links</h5>
                    <div class="d-flex flex-wrap gap-3">
                        <a href="<?= base_url('/auth/biodata') ?>" class="btn btn-outline-primary">Manage Biodata</a>
                        <a href="<?= base_url('/auth/pendidikan') ?>" class="btn btn-outline-success">Manage Pendidikan</a>
                        <a href="<?= base_url('/auth/aktivitas') ?>" class="btn btn-outline-warning">Manage Aktivitas</a>
                        <a href="<?= base_url('/auth/manage') ?>" class="btn btn-outline-secondary">Manage Admin</a>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Logout Button -->
    <div class="row mt-4">
        <div class="col-md-12 text-end">
            <a href="<?= base_url('/logout') ?>" class="btn btn-danger">Logout</a>
        </div>
    </div>

</div>

<?= $this->include('layout/footer_admin') ?>